/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.presentation;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org2.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org2.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org2.eclipse.php.internal.debug.core.sourcelookup.PHPSourceNotFoundInput;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org2.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org2.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org2.eclipse.php.internal.debug.ui.breakpoint.PHPBreakpointImageDescriptor;
import org2.eclipse.php.internal.debug.ui.console.SourceDisplayUtil;
import org2.eclipse.php.internal.debug.ui.sourcelookup.PHPSourceNotFoundEditorInput;
import org2.eclipse.php.internal.debug.ui.util.ImageDescriptorRegistry;

public class PHPModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    protected static final String UNTITLED_FOLDER_PATH = "Untitled_Documents";
    private ImageDescriptorRegistry fDebugImageRegistry;

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof PHPConditionalBreakpoint) {
            return this.getBreakpointImage((PHPConditionalBreakpoint)((Object)element));
        }
        return null;
    }

    private Image getBreakpointImage(PHPConditionalBreakpoint breakpoint) {
        try {
            if (breakpoint.isConditionEnabled()) {
                PHPBreakpointImageDescriptor descriptor = breakpoint.isEnabled() ? new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), 96) : new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), 64);
                return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    protected ImageDescriptorRegistry getDebugImageRegistry() {
        if (this.fDebugImageRegistry == null) {
            this.fDebugImageRegistry = PHPDebugEPLPlugin.getImageDescriptorRegistry();
        }
        return this.fDebugImageRegistry;
    }

    public String getText(Object element) {
        if (element instanceof PHPDebugTarget) {
            return this.getTargetText((PHPDebugTarget)element);
        }
        if (element instanceof PHPThread) {
            return this.getThreadText((PHPThread)((Object)element));
        }
        if (element instanceof PHPStackFrame) {
            return this.getStackFrameText((PHPStackFrame)((Object)element));
        }
        if (element instanceof PHPLineBreakpoint) {
            PHPLineBreakpoint breakpoint = (PHPLineBreakpoint)((Object)element);
            IMarker marker = breakpoint.getMarker();
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                return null;
            }
            if (resource instanceof IWorkspaceRoot) {
                try {
                    String filename = (String)marker.getAttribute("org2.eclipse.php.debug.core.Storage_File");
                    Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
                    return String.valueOf(filename) + " [line: " + lineNumber.toString() + "]";
                }
                catch (CoreException e) {
                    PHPDebugEPLPlugin.logError("Unexpected error in PHPModelPresentation", e);
                }
            }
        }
        return null;
    }

    private String getTargetText(PHPDebugTarget target) {
        String label = "";
        if (target.isTerminated()) {
            label = MessageFormat.format(PHPDebugUIMessages.MPresentation_Terminated_1, new Object[0]);
        }
        label = String.valueOf(label) + PHPDebugUIMessages.MPresentation_PHP_APP_1;
        int debugPort = PHPDebugEPLPlugin.getDebugPort("org2.eclipse.php.debug.core.zendDebugger");
        return String.valueOf(label) + " (port " + debugPort + ')';
    }

    private String getThreadText(PHPThread thread) {
        PHPDebugTarget target = (PHPDebugTarget)thread.getDebugTarget();
        String label = "";
        try {
            label = target.getName();
        }
        catch (DebugException e1) {
            PHPDebugEPLPlugin.logError("PHPModelPresentation error getting target name", e1);
        }
        if (thread.isStepping()) {
            label = String.valueOf(label) + PHPDebugUIMessages.MPresentation_Stepping_1;
        } else if (thread.isSuspended()) {
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            if (breakpoints.length == 0) {
                label = String.valueOf(label) + PHPDebugUIMessages.MPresentation_Suspended_1;
            } else {
                IBreakpoint breakpoint = breakpoints[0];
                if (breakpoint instanceof PHPLineBreakpoint) {
                    label = String.valueOf(label) + PHPDebugUIMessages.MPresentation_SLineBreakpoint_1;
                }
            }
        } else if (thread.isTerminated()) {
            label = String.valueOf(PHPDebugUIMessages.MPresentation_Terminated_1) + label;
        }
        return label;
    }

    private String getStackFrameText(PHPStackFrame frame) {
        try {
            StringBuffer buffer = new StringBuffer();
            String frameName = frame.getName();
            if (frameName != null && frameName.length() > 0) {
                buffer.append(frame.getName());
                buffer.append("(): ");
            }
            buffer.append(frame.getSourceName());
            buffer.append(String.valueOf(PHPDebugUIMessages.MPresentation_ATLine_1) + frame.getLineNumber());
            return buffer.toString();
        }
        catch (DebugException e) {
            PHPDebugEPLPlugin.logError("Unexpected error in PHPModelPresentation", e);
        }
        catch (NullPointerException npe) {
            StringBuffer errorMessage = new StringBuffer("NPE in getStackFrameText(). Frame = ");
            errorMessage.append((Object)frame);
            if (frame != null) {
                errorMessage.append(", Thread = ");
                errorMessage.append(frame.getThread());
            }
            PHPDebugEPLPlugin.logError(errorMessage.toString(), npe);
        }
        return "";
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        IFileStore localFile;
        File file;
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IFileStore) {
            try {
                return SourceDisplayUtil.getEditorInput(((IFileStore)element).toLocalFile(0, null));
            }
            catch (CoreException coreException) {}
        }
        if (element instanceof PHPSourceNotFoundInput) {
            return new PHPSourceNotFoundEditorInput((PHPSourceNotFoundInput)element);
        }
        if (element instanceof PHPLineBreakpoint) {
            PHPLineBreakpoint breakpoint = (PHPLineBreakpoint)((Object)element);
            IMarker marker = breakpoint.getMarker();
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (element instanceof PHPSourceNotFoundInput) {
                return new PHPSourceNotFoundEditorInput((PHPSourceNotFoundInput)element);
            }
        }
        if (element instanceof IFileStore && (file = new File((localFile = (IFileStore)element).toString())).exists()) {
            return new FileStoreEditorInput(localFile);
        }
        PHPDebugEPLPlugin.logError("Unknown editor input type: " + element.getClass().getName());
        return null;
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    protected boolean isUntitled(Object element) {
        IFileStore localFile;
        IFileStore parentDir;
        return element instanceof IFileStore && (parentDir = (localFile = (IFileStore)element).getParent()) != null && UNTITLED_FOLDER_PATH.equals(parentDir.getName());
    }
}

